/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __RESTRICT_FS_BPF_SKEL_H__
#define __RESTRICT_FS_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct restrict_fs_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *cgroup_hash;
	} maps;
	struct {
		struct bpf_program *restrict_filesystems;
	} progs;
	struct {
		struct bpf_link *restrict_filesystems;
	} links;

#ifdef __cplusplus
	static inline struct restrict_fs_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct restrict_fs_bpf *open_and_load();
	static inline int load(struct restrict_fs_bpf *skel);
	static inline int attach(struct restrict_fs_bpf *skel);
	static inline void detach(struct restrict_fs_bpf *skel);
	static inline void destroy(struct restrict_fs_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
restrict_fs_bpf__destroy(struct restrict_fs_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
restrict_fs_bpf__create_skeleton(struct restrict_fs_bpf *obj);

static inline struct restrict_fs_bpf *
restrict_fs_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct restrict_fs_bpf *obj;
	int err;

	obj = (struct restrict_fs_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = restrict_fs_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	restrict_fs_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct restrict_fs_bpf *
restrict_fs_bpf__open(void)
{
	return restrict_fs_bpf__open_opts(NULL);
}

static inline int
restrict_fs_bpf__load(struct restrict_fs_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct restrict_fs_bpf *
restrict_fs_bpf__open_and_load(void)
{
	struct restrict_fs_bpf *obj;
	int err;

	obj = restrict_fs_bpf__open();
	if (!obj)
		return NULL;
	err = restrict_fs_bpf__load(obj);
	if (err) {
		restrict_fs_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
restrict_fs_bpf__attach(struct restrict_fs_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
restrict_fs_bpf__detach(struct restrict_fs_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *restrict_fs_bpf__elf_bytes(size_t *sz);

static inline int
restrict_fs_bpf__create_skeleton(struct restrict_fs_bpf *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "restrict_fs_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 1;
	s->map_skel_sz = sizeof(*s->maps);
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt, s->map_skel_sz);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	s->maps[0].name = "cgroup_hash";
	s->maps[0].map = &obj->maps.cgroup_hash;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "restrict_filesystems";
	s->progs[0].prog = &obj->progs.restrict_filesystems;
	s->progs[0].link = &obj->links.restrict_filesystems;

	s->data = restrict_fs_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *restrict_fs_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x58\x09\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x09\0\
\x01\0\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x6c\x73\
\x6d\x2f\x66\x69\x6c\x65\x5f\x6f\x70\x65\x6e\0\x6c\x69\x63\x65\x6e\x73\x65\0\
\x2e\x6d\x61\x70\x73\0\x72\x65\x73\x74\x72\x69\x63\x74\x2d\x66\x73\x2e\x62\x70\
\x66\x2e\x63\0\x4c\x42\x42\x30\x5f\x37\0\x4c\x42\x42\x30\x5f\x35\0\x4c\x42\x42\
\x30\x5f\x36\0\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\x72\x65\x73\x74\x72\x69\x63\
\x74\x5f\x66\x69\x6c\x65\x73\x79\x73\x74\x65\x6d\x73\0\x63\x67\x72\x6f\x75\x70\
\x5f\x68\x61\x73\x68\0\x2e\x72\x65\x6c\x6c\x73\x6d\x2f\x66\x69\x6c\x65\x5f\x6f\
\x70\x65\x6e\0\x2e\x42\x54\x46\0\x2e\x42\x54\x46\x2e\x65\x78\x74\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2d\0\0\0\x04\0\xf1\xff\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x3f\0\0\
\0\0\0\x03\0\xf0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x46\0\0\0\0\0\x03\0\xd0\x01\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x4d\0\0\0\0\0\x03\0\xe8\x01\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x54\0\0\0\x01\0\x04\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\x03\0\x04\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x5d\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\xf8\
\x01\0\0\0\0\0\0\x72\0\0\0\x11\0\x05\0\0\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x79\
\x13\0\0\0\0\0\0\x79\x10\x08\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x63\x1a\xe8\xff\0\0\
\0\0\xbf\x01\0\0\0\0\0\0\x67\x01\0\0\x20\0\0\0\x77\x01\0\0\x20\0\0\0\x55\x01\
\x36\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x0f\x13\0\0\0\0\0\0\xbf\xa6\0\0\0\0\0\0\x07\
\x06\0\0\xf0\xff\xff\xff\xbf\x61\0\0\0\0\0\0\xb7\x02\0\0\x08\0\0\0\x85\0\0\0\
\x71\0\0\0\xb7\x01\0\0\0\0\0\0\x79\xa3\xf0\xff\0\0\0\0\x0f\x13\0\0\0\0\0\0\xbf\
\x61\0\0\0\0\0\0\xb7\x02\0\0\x08\0\0\0\x85\0\0\0\x71\0\0\0\xb7\x01\0\0\0\0\0\0\
\x79\xa3\xf0\xff\0\0\0\0\x0f\x13\0\0\0\0\0\0\xbf\xa1\0\0\0\0\0\0\x07\x01\0\0\
\xf8\xff\xff\xff\xb7\x02\0\0\x08\0\0\0\x85\0\0\0\x71\0\0\0\x79\xa1\xf8\xff\0\0\
\0\0\x63\x1a\xec\xff\0\0\0\0\x85\0\0\0\x50\0\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\
\xa2\0\0\0\0\0\0\x07\x02\0\0\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x85\0\0\0\x01\0\0\0\xbf\x06\0\0\0\0\0\0\xb7\0\0\0\0\0\0\0\x15\x06\x16\0\0\0\
\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe8\xff\xff\xff\xbf\x61\0\0\0\0\0\0\x85\0\
\0\0\x01\0\0\0\xbf\x01\0\0\0\0\0\0\xb7\0\0\0\0\0\0\0\x15\x01\x0f\0\0\0\0\0\x61\
\x17\0\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xec\xff\xff\xff\xbf\x61\0\0\0\
\0\0\0\x85\0\0\0\x01\0\0\0\xbf\x01\0\0\0\0\0\0\x15\x07\x04\0\0\0\0\0\x18\0\0\0\
\xff\xff\xff\xff\0\0\0\0\0\0\0\0\x15\x01\x05\0\0\0\0\0\x05\0\x03\0\0\0\0\0\x18\
\0\0\0\xff\xff\xff\xff\0\0\0\0\0\0\0\0\x55\x01\x01\0\0\0\0\0\xb7\0\0\0\0\0\0\0\
\x95\0\0\0\0\0\0\0\x47\x50\x4c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x10\x01\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\
\0\0\xfc\x01\0\0\xfc\x01\0\0\x57\x01\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\
\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\
\x0d\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\
\x19\0\0\0\0\0\0\x08\x07\0\0\0\x22\0\0\0\0\0\0\x08\x08\0\0\0\x2d\0\0\0\0\0\0\
\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\x02\x0a\0\0\0\x3b\0\0\0\0\0\0\x08\x0b\0\
\0\0\x44\0\0\0\0\0\0\x08\x0c\0\0\0\x4f\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\
\0\0\x03\0\0\x04\x18\0\0\0\x5c\0\0\0\x01\0\0\0\0\0\0\0\x61\0\0\0\x05\0\0\0\x40\
\0\0\0\x65\0\0\0\x09\0\0\0\x80\0\0\0\x6b\0\0\0\0\0\0\x0e\x0d\0\0\0\x01\0\0\0\0\
\0\0\0\0\0\0\x02\x10\0\0\0\x77\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x01\
\0\0\x0d\x02\0\0\0\x8a\0\0\0\x0f\0\0\0\x8e\0\0\0\x01\0\0\x0c\x11\0\0\0\xa3\0\0\
\0\x01\0\0\x04\x08\0\0\0\xa8\0\0\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x02\x15\0\0\
\0\xb0\0\0\0\x01\0\0\x04\x08\0\0\0\xb6\0\0\0\x16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x02\x17\0\0\0\xbb\0\0\0\x01\0\0\x04\x08\0\0\0\xc7\0\0\0\x08\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x0a\x19\0\0\0\xcf\0\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\
\0\x03\0\0\0\0\x18\0\0\0\x04\0\0\0\x04\0\0\0\xd4\0\0\0\0\0\0\x0e\x1a\0\0\0\0\0\
\0\0\x3b\x01\0\0\x01\0\0\x0f\x04\0\0\0\x1b\0\0\0\0\0\0\0\x04\0\0\0\x43\x01\0\0\
\x01\0\0\x0f\x18\0\0\0\x0e\0\0\0\0\0\0\0\x18\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\
\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x75\x69\x6e\
\x74\x36\x34\x5f\x74\0\x5f\x5f\x75\x69\x6e\x74\x36\x34\x5f\x74\0\x75\x6e\x73\
\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\0\x75\x69\x6e\x74\x33\x32\x5f\x74\0\
\x5f\x5f\x75\x69\x6e\x74\x33\x32\x5f\x74\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\
\x69\x6e\x74\0\x74\x79\x70\x65\0\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\x63\x67\
\x72\x6f\x75\x70\x5f\x68\x61\x73\x68\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\
\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x63\x74\x78\0\x72\x65\x73\x74\x72\x69\x63\
\x74\x5f\x66\x69\x6c\x65\x73\x79\x73\x74\x65\x6d\x73\0\x66\x69\x6c\x65\0\x66\
\x5f\x69\x6e\x6f\x64\x65\0\x69\x6e\x6f\x64\x65\0\x69\x5f\x73\x62\0\x73\x75\x70\
\x65\x72\x5f\x62\x6c\x6f\x63\x6b\0\x73\x5f\x6d\x61\x67\x69\x63\0\x63\x68\x61\
\x72\0\x5f\x6c\x69\x63\x65\x6e\x73\x65\0\x2f\x75\x73\x72\x2f\x73\x72\x63\x2f\
\x64\x65\x62\x75\x67\x2f\x73\x79\x73\x74\x65\x6d\x64\x2f\x62\x75\x69\x6c\x64\
\x2f\x2e\x2e\x2f\x73\x79\x73\x74\x65\x6d\x64\x2d\x73\x74\x61\x62\x6c\x65\x2f\
\x73\x72\x63\x2f\x63\x6f\x72\x65\x2f\x62\x70\x66\x2f\x72\x65\x73\x74\x72\x69\
\x63\x74\x5f\x66\x73\x2f\x72\x65\x73\x74\x72\x69\x63\x74\x2d\x66\x73\x2e\x62\
\x70\x66\x2e\x63\0\x30\x3a\x30\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x6d\x61\x70\
\x73\0\x6c\x73\x6d\x2f\x66\x69\x6c\x65\x5f\x6f\x70\x65\x6e\0\0\0\0\0\0\x9f\xeb\
\x01\0\x20\0\0\0\0\0\0\0\x14\0\0\0\x14\0\0\0\x7c\x01\0\0\x90\x01\0\0\x3c\0\0\0\
\x08\0\0\0\x49\x01\0\0\x01\0\0\0\0\0\0\0\x12\0\0\0\x10\0\0\0\x49\x01\0\0\x17\0\
\0\0\0\0\0\0\xdd\0\0\0\0\0\0\0\x05\xa0\0\0\x18\0\0\0\xdd\0\0\0\0\0\0\0\x34\xb0\
\0\0\x20\0\0\0\xdd\0\0\0\0\0\0\0\x05\xa0\0\0\x38\0\0\0\xdd\0\0\0\0\0\0\0\x0d\
\xc0\0\0\x58\0\0\0\xdd\0\0\0\0\0\0\0\0\0\0\0\x60\0\0\0\xdd\0\0\0\0\0\0\0\x09\
\xcc\0\0\xc8\0\0\0\xdd\0\0\0\0\0\0\0\0\0\0\0\xd0\0\0\0\xdd\0\0\0\0\0\0\0\x09\
\xcc\0\0\xe0\0\0\0\xdd\0\0\0\0\0\0\0\x22\xdc\0\0\xe8\0\0\0\xdd\0\0\0\0\0\0\0\
\x16\xdc\0\0\xf0\0\0\0\xdd\0\0\0\0\0\0\0\x15\xe4\0\0\xf8\0\0\0\xdd\0\0\0\0\0\0\
\0\x13\xe4\0\0\x08\x01\0\0\xdd\0\0\0\0\0\0\0\0\0\0\0\x10\x01\0\0\xdd\0\0\0\0\0\
\0\0\x15\xec\0\0\x38\x01\0\0\xdd\0\0\0\0\0\0\0\x0d\xf0\0\0\x48\x01\0\0\xdd\0\0\
\0\0\0\0\0\x14\xfc\0\0\x70\x01\0\0\xdd\0\0\0\0\0\0\0\x0d\0\x01\0\x78\x01\0\0\
\xdd\0\0\0\0\0\0\0\x0d\x14\x01\0\x90\x01\0\0\xdd\0\0\0\0\0\0\0\0\0\0\0\xa8\x01\
\0\0\xdd\0\0\0\0\0\0\0\x0d\x14\x01\0\xc0\x01\0\0\xdd\0\0\0\0\0\0\0\x15\x1c\x01\
\0\xe0\x01\0\0\xdd\0\0\0\0\0\0\0\x15\x2c\x01\0\xf0\x01\0\0\xdd\0\0\0\0\0\0\0\
\x05\xa0\0\0\x10\0\0\0\x49\x01\0\0\x03\0\0\0\x40\0\0\0\x13\0\0\0\x37\x01\0\0\0\
\0\0\0\x78\0\0\0\x15\0\0\0\x37\x01\0\0\0\0\0\0\xa8\0\0\0\x17\0\0\0\x37\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\
\x03\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x9e\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x09\0\0\0\x02\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\xf0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\
\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x11\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xd0\x01\0\0\0\0\0\0\xf8\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x1f\0\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xc8\x03\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x27\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd0\x03\0\0\
\0\0\0\0\x18\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x7e\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe8\x03\0\0\0\0\0\0\x10\
\0\0\0\0\0\0\0\x02\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x90\0\0\
\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf8\x03\0\0\0\0\0\0\x6b\x03\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x95\0\0\0\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x68\x07\0\0\0\0\0\0\xec\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct restrict_fs_bpf *restrict_fs_bpf::open(const struct bpf_object_open_opts *opts) { return restrict_fs_bpf__open_opts(opts); }
struct restrict_fs_bpf *restrict_fs_bpf::open_and_load() { return restrict_fs_bpf__open_and_load(); }
int restrict_fs_bpf::load(struct restrict_fs_bpf *skel) { return restrict_fs_bpf__load(skel); }
int restrict_fs_bpf::attach(struct restrict_fs_bpf *skel) { return restrict_fs_bpf__attach(skel); }
void restrict_fs_bpf::detach(struct restrict_fs_bpf *skel) { restrict_fs_bpf__detach(skel); }
void restrict_fs_bpf::destroy(struct restrict_fs_bpf *skel) { restrict_fs_bpf__destroy(skel); }
const void *restrict_fs_bpf::elf_bytes(size_t *sz) { return restrict_fs_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
restrict_fs_bpf__assert(struct restrict_fs_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __RESTRICT_FS_BPF_SKEL_H__ */
