#!/bin/bash
#
# Create lvm snapshots
# Copyright Daniel Mehrmann (Akusari) 2024
#

#
# settings
#

source /usr/local/etc/make_backup.conf
volume_array=($lvm_volumes)

### prepare filesystem as good as possible ###

/usr/bin/sync

### create snapshots ###

for volume in "${volume_array[@]}"; do
   /usr/sbin/lvcreate -L 4G -n snap-"${volume}" -s ${lvm_group}/"${volume}" || exit 255
done

exit 0
