#!/bin/bash
#
# Unmount created snapshot for a backup
# Copyright Daniel Mehrmann (Akusari) 2024
# 
# You could do it at once with umount -R <root-fs>
#

#
# settings
#

source /usr/local/etc/make_backup.conf
volume_array=($lvm_volumes)

### unmount snapshots ###

for volume in "${volume_array[@]}"; do
   if [ "$volume" == "root" ]; then
      echo "Skipping root fs for now..."
      continue
   fi

   /usr/bin/umount /mnt/"${volume}" || exit 255
done

### unmount snapshot root ###

sleep 2
/usr/bin/umount /mnt || exit 255

exit 0
